/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class TextureLoader
implements ITextureLoader {
    public static final int[] anIntArray1896 = new int[256];
    public static double aDouble1897 = -1.0;

    @Override
    public float[] get_diffuse_hdr_pixels(TextureType type, int id, float mutliplier, int width, int height, boolean bool) {
        return this.get_diffuse_hdr_pixels(type, id, mutliplier);
    }

    private float[] get_diffuse_hdr_pixels(TextureType type, int id, double mutliplier) {
        if (TextureType.DIFFUES_HDR != type) {
            return null;
        }
        int[] diffuse_pixels = this.get_pixels(type, id, mutliplier);
        if (diffuse_pixels == null) {
            return null;
        }
        int[] hdr_pixels = null;
        byte[] hdr_data = this.get_texture_data(TextureType.DIFFUSE, id);
        if (hdr_data != null) {
            block9: {
                byte num_images = (byte)(hdr_data[0] & 0xFF);
                if (num_images == 1) break block9;
                return null;
            }
            try {
                byte[] hdr_image_file = new byte[hdr_data.length - 5];
                System.arraycopy(hdr_data, 5, hdr_image_file, 0, hdr_data.length - 5);
                hdr_pixels = this.get_image_pixels(hdr_image_file, false);
                int index = 0;
                while (index < hdr_pixels.length) {
                    hdr_pixels[index] = hdr_pixels[index] & 0xFF;
                    ++index;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (hdr_pixels == null) {
            hdr_pixels = new int[diffuse_pixels.length];
        }
        float[] normalized_pixels = new float[4 * diffuse_pixels.length];
        int offset = 0;
        int pixel = 0;
        while (pixel < diffuse_pixels.length) {
            int diffuse_pixel = diffuse_pixels[pixel];
            int alpha = diffuse_pixel >>> 24;
            int red = (diffuse_pixel & 0xFF0000) >> 16;
            int green = (diffuse_pixel & 0xFF00) >> 8;
            int blue = diffuse_pixel & 0xFF;
            float hdr_value = 1.0f + 31.0f * (float)hdr_pixels[pixel] / 4096.0f;
            normalized_pixels[offset++] = (float)red * hdr_value / 255.0f;
            normalized_pixels[offset++] = (float)green * hdr_value / 255.0f;
            normalized_pixels[offset++] = (float)blue * hdr_value / 255.0f;
            normalized_pixels[offset++] = (float)alpha / 255.0f;
            ++pixel;
        }
        return normalized_pixels;
    }

    @Override
    public int[] loadTranslucent(TextureType type, int id, float multiplier, int width, int height, boolean bool) {
        return this.get_pixels_transparent(type, id, multiplier);
    }

    public int[] get_pixels_transparent(TextureType type, int id, double multiplier) {
        int[] is = this.get_pixels(type, id, multiplier);
        if (is == null) {
            return null;
        }
        int i_16_ = 0;
        while (i_16_ < is.length) {
            is[i_16_] = (is[i_16_] & 0xFFFFFF) != 0 ? is[i_16_] | 0xFF000000 : is[i_16_] & 0xFFFFFF;
            ++i_16_;
        }
        return is;
    }

    @Override
    public int[] loadOpaque(TextureType type, int id, float multiplier, int width, int height, boolean bool) {
        return this.get_pixels(type, id, multiplier);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int[] get_pixels(TextureType type, int id, double multiplier) {
        byte[] data = this.get_texture_data(type, id);
        if (data == null) {
            return null;
        }
        try {
            byte numTextures = (byte)(data[0] & 0xFF);
            if (TextureType.DIFFUSE == type) {
                if (numTextures != 6) {
                    return null;
                }
                int[] pixels_buffer = null;
                int offset = 1;
                int image_index = 0;
                while (image_index < 6) {
                    int image_size = (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
                    byte[] image_file = new byte[image_size];
                    System.arraycopy(data, 4 + offset, image_file, 0, image_size);
                    int[] diffuse_pixels = this.get_image_pixels(image_file, false);
                    if (image_index == 0) {
                        pixels_buffer = new int[6 * diffuse_pixels.length];
                    }
                    System.arraycopy(diffuse_pixels, 0, pixels_buffer, image_index * diffuse_pixels.length, diffuse_pixels.length);
                    offset += 4 + image_size;
                    ++image_index;
                }
                if (multiplier != 1.0) {
                    TextureLoader.method7293(pixels_buffer, multiplier);
                }
                return pixels_buffer;
            }
            if (numTextures != 1) {
                return null;
            }
            byte[] space_buffer = new byte[data.length - 5];
            System.arraycopy(data, 5, space_buffer, 0, data.length - 5);
            int[] pixels_buffer = this.get_image_pixels(space_buffer, false);
            if (pixels_buffer == null) {
                return null;
            }
            if (multiplier != 1.0) {
                TextureLoader.method7293(pixels_buffer, multiplier);
            }
            return pixels_buffer;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public abstract boolean is_ready(TextureType var1, int var2, TextureChannel var3, float var4, int var5, int var6, boolean var7);

    public abstract byte[] get_texture_data(TextureType var1, int var2);

    @Override
    public void frame_rendered_event() {
    }

    private int[] get_image_pixels(byte[] data, boolean fliped) throws IOException {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
        if (image == null) {
            return null;
        }
        int[] pixels = TextureLoader.get_image_pixels(image);
        if (fliped) {
            int y = image.getHeight() - 1;
            while (y >= 0) {
                int offset = y * image.getWidth();
                int x = (1 + y) * image.getWidth();
                while (offset < x) {
                    int i_33_ = pixels[offset];
                    pixels[offset] = pixels[--x];
                    pixels[x] = i_33_;
                    ++offset;
                }
                --y;
            }
        }
        return pixels;
    }

    public static int[] get_image_pixels(BufferedImage image) {
        if (image.getType() == 10 || image.getType() == 0) {
            int[] temp = null;
            temp = image.getRaster().getPixels(0, 0, image.getWidth(), image.getHeight(), temp);
            int[] pixels = new int[image.getWidth() * image.getHeight()];
            if (image.getType() == 10) {
                int index = 0;
                while (index < pixels.length) {
                    pixels[index] = 0xFF000000 | temp[index] << 16 | temp[index] << 8 | temp[index];
                    ++index;
                }
            } else {
                int index = 0;
                while (index < pixels.length) {
                    int new_index = index * 2;
                    pixels[index] = (temp[new_index] << 8) + (temp[new_index] << 16) + temp[new_index] + (temp[new_index + 1] << 24);
                    ++index;
                }
            }
            return pixels;
        }
        return image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
    }

    private static void method7293(int[] is, double d) {
        int i;
        if (aDouble1897 != d) {
            i = 0;
            while (i < 256) {
                int i_46_ = (int)(Math.pow((double)i / 255.0, d) * 255.0);
                TextureLoader.anIntArray1896[i] = i_46_ > 255 ? 255 : i_46_;
                ++i;
            }
            aDouble1897 = d;
        }
        i = 0;
        while (i < is.length) {
            int i_47_ = anIntArray1896[is[i] >> 16 & 0xFF];
            int i_48_ = anIntArray1896[is[i] >> 8 & 0xFF];
            int i_49_ = anIntArray1896[is[i] >> 0 & 0xFF];
            is[i] = is[i] & 0xFF000000 | i_47_ << 16 | i_48_ << 8 | i_49_;
            ++i;
        }
    }
}

